
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

    [TestFixture]
    public class BOL_UnitFilter : BaseTest 
    {


        private UnitFilter _tstUF;
        private DataTable _dtUnits;

        [SetUp]
        protected void SetUp() 
        {
            this.BaseSetUp();

			if (this.RefreshData)
			{
                this._dtUnits = BOL.BloodUnit.GetLimitedBloodUnitsByDivision(UnitTestConfig.TestDivisionCode, false);

				this.RefreshData = false;
			}

			_tstUF = new UnitFilter(this._dtUnits, null);
        }

		
		[Test]
		public void Ctor_DataTable_DataTable_Pass()
		{
			DataTable dtInitial = BOL.BloodUnit.GetLimitedBloodUnitsByDivision(UnitTestConfig.TestDivisionCode, true);
			DataTable dtSelected = dtInitial.Clone();

			BOL.UnitFilter tstValue = new BOL.UnitFilter(dtInitial, dtSelected);

			Assert.IsNotNull(tstValue);
			Assert.AreEqual(dtSelected, tstValue.SelectedUnits, "SelectedUnits");
			Assert.AreEqual(dtInitial, tstValue.InitialUnits, "IntialUnits");
		}

		[Test]
		[ExpectedException(typeof(BusinessObjectException))]
		public void Ctor_DataTable_DataTable_Fail()
		{
			BOL.UnitFilter tstValue = new BOL.UnitFilter(new DataTable(), new DataTable());
		}
		
		[Test]
		public void Ctor_Bool_Pass()
		{
			BOL.UnitFilter tstValue = new BOL.UnitFilter(true);

			Assert.IsNotNull(tstValue);
			Assert.AreEqual(0, tstValue.InitialUnits.Rows.Count, "InitialUnits.Rows.Count");
			Assert.AreEqual(0, tstValue.SelectedUnits.Rows.Count, "SelectedUnits.Rows.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Bool_Fail()
		{
		}
		
		[Test]
		public void AddAboRhToFilter_Pass()
		{
			string aboRh = "A";
			_tstUF.AddAboRhToFilter(aboRh);
			Assert.IsTrue(true);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void AddAboRhToFilter_Fail()
		{
			_tstUF.AddAboRhToFilter(null);
		}

		[Test]
		public void AddCMVToFilter_Pass()
		{
			_tstUF.AddCMVToFilter(System.Guid.NewGuid());
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AddCMVToFilter_Fail()
		{
		}

		[Test]
		public void AddExpirationAfterDateToFilter_Pass()
		{
			_tstUF.AddExpirationAfterDateToFilter(DateTime.Now);
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AddExpirationAfterDateToFilter_Fail()
		{
		}

		[Test]
		public void AddExpirationBeforeDateToFilter_Pass()
		{
			_tstUF.AddExpirationBeforeDateToFilter(DateTime.Now);
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AddExpirationBeforeDateToFilter_Fail()
		{
		}

		[Test]
		public void AddProductTypeCodeToFilter_Pass()
		{
			_tstUF.AddProductTypeCodeToFilter("1234");
			Assert.IsTrue(true);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void AddProductTypeCodeToFilter_Fail()
		{
			_tstUF.AddProductTypeCodeToFilter(null);
			Assert.IsTrue(true);
		}

		[Test]
		public void AddReceivedAfterDateToFilter_Pass()
		{
			_tstUF.AddReceivedAfterDateToFilter(DateTime.Now);
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AddReceivedAfterDateToFilter_Fail()
		{
		}

		[Test]
		public void AddReceivedBeforeDateToFilter_Pass()
		{
			_tstUF.AddReceivedBeforeDateToFilter(DateTime.Now);
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AddReceivedBeforeDateToFilter_Fail()
		{
		}

		[Test]
		public void AddSickleCellToFilter_Pass()
		{
			_tstUF.AddSickleCellToFilter(System.Guid.NewGuid());
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AddSickleCellToFilter_Fail()
		{
		}

		[Test]
		public void AddSpecialTestingToFilter_Pass()
		{
			_tstUF.AddSpecialTestingToFilter(System.Guid.NewGuid());
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void AddSpecialTestingToFilter_Fail()
		{
		}

		[Test]
		public void FilteredUnitsView_Pass()
		{
			DataTable dtInitial = BOL.BloodUnit.GetLimitedBloodUnitsByDivision(UnitTestConfig.TestDivisionCode, false);
			System.Guid filterGuid = (System.Guid)dtInitial.Rows[0][TABLES.BloodUnit.BloodUnitGuid];

			BOL.UnitFilter tstValue = new BOL.UnitFilter(dtInitial, null);

			tstValue.AddSpecialTestingToFilter(filterGuid);

			Assert.AreEqual(1, tstValue.FilteredUnitsView.Count, "FilterView.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void FilteredUnitsView_Fail()
		{
		}

				
		[Test]
		public void InitialUnits_Pass()
		{
            DataTable dtInitial = BOL.BloodUnit.GetLimitedBloodUnitsByDivision(UnitTestConfig.TestDivisionCode, false);

			this._tstUF.InitialUnits = dtInitial;

			Assert.AreEqual(dtInitial, this._tstUF.InitialUnits);
		}

		[Test]
		[ExpectedException(typeof(BusinessObjectException))]
		public void InitialUnits_Fail()
		{
			this._tstUF.InitialUnits = new DataTable();
		}
				

		[Test]
		public void RemoveCMVFromFilter_Pass()
		{
			_tstUF.RemoveCMVFromFilter(System.Guid.NewGuid());
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RemoveCMVFromFilter_Fail()
		{
		}

		[Test]
		public void RemoveExpirationAfterDateFromFilter_Pass()
		{
			_tstUF.RemoveExpirationAfterDateFromFilter(DateTime.Now);
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RemoveExpirationAfterDateFromFilter_Fail()
		{
		}

		[Test]
		public void RemoveExpirationBeforeDateFromFilter_Pass()
		{
			_tstUF.RemoveExpirationBeforeDateFromFilter(DateTime.Now);
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RemoveExpirationBeforeDateFromFilter_Fail()
		{
		}

        [Test]
                public void RemoveProductTypeCodeFromFilter_Pass()
        {

            _tstUF.RemoveProductTypeCodeFromFilter("1234");
            Assert.IsTrue(true);
        }

        [Test]
        [Ignore(StandardIgnoreReasons.NoFailureConditions)]
        public void RemoveProductTypeCodeFromFilter_Fail()
        {
        }

		[Test]
		public void RemoveReceivedAfterDateFromFilter_Pass()
		{
			_tstUF.RemoveReceivedAfterDateFromFilter(DateTime.Now);
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RemoveReceivedAfterDateFromFilter_Fail()
		{
		}

		[Test]
		public void RemoveReceivedBeforeDateFromFilter_Pass()
		{
			_tstUF.RemoveReceivedBeforeDateFromFilter(DateTime.Now);
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RemoveReceivedBeforeDateFromFilter_Fail()
		{
		}

		[Test]
		public void RemoveSickleCellFromFilter_Pass()
		{
			_tstUF.RemoveSickleCellFromFilter(System.Guid.NewGuid());
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RemoveSickleCellFromFilter_Fail()
		{
		}

		[Test]
		public void RemoveSpecialTestingFromFilter_Pass()
		{
			_tstUF.RemoveSpecialTestingFromFilter(System.Guid.NewGuid());
			Assert.IsTrue(true);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RemoveSpecialTestingFromFilter_Fail()
		{
		}

		[Test]
		public void SelectedUnits_Pass()
		{
            DataTable dtSelected = BOL.BloodUnit.GetLimitedBloodUnitsByDivision(UnitTestConfig.TestDivisionCode, false);

			this._tstUF.SelectedUnits = dtSelected;

			Assert.AreEqual(dtSelected, this._tstUF.SelectedUnits);
		}

		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException))]
		public void SelectedUnits_Fail()
		{
			DataTable dtBogus = new DataTable();
			dtBogus.Columns.Add("Stinky", typeof(string));

			this._tstUF.SelectedUnits = dtBogus;
		}


		[Test]
                public void RemoveAboRhFromFilter_Pass()
        {
            string aboRh = "";
            _tstUF.RemoveAboRhFromFilter(aboRh);
            Assert.IsTrue(true, "UnitFilterUnitTest.TestUnitFilter_RemoveAboRhFromFilter_Pass ");
        }

        [Test]
                public void RemoveAboRhFromFilter_Fail()
        {
            string aboRh = "";
            _tstUF.RemoveAboRhFromFilter(aboRh);
            Assert.IsTrue(true, "UnitFilterUnitTest.TestUnitFilter_RemoveAboRhFromFilter_Fail ");
        }


		[Test]
		public void VerifyMinColumnsInDataTable_Pass()
		{
            DataTable dtTest = BOL.BloodUnit.GetLimitedBloodUnitsByDivision(UnitTestConfig.TestDivisionCode, false);
			string[] colNames = BOL.UnitFilter.MIN_COLUMNS.Split(',');

			bool retval = _tstUF.VerifyMinColumnsInDataTable(colNames, dtTest);

			Assert.AreEqual(true, retval);
		}

		[Test]
		public void VerifyMinColumnsInDataTable_Fail()
		{
			string[] colNames = BOL.UnitFilter.MIN_COLUMNS.Split(',');

			DataTable dtTable = new DataTable();
			
			bool retval =_tstUF.VerifyMinColumnsInDataTable(colNames, dtTable);

			
			Assert.AreEqual(false, retval);
		}





    }
}
#endif

